/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.himinbi.geom.Bounds;
import org.himinbi.util.Runner;

public class ScaleTest
extends JPanel {
    final int NUM_SQUARES = 4;
    int minSize = 20;
    boolean antialias = true;
    Bounds armNumberBounds = new Bounds(2.0, 9.0);
    Bounds dashLengthBounds = new Bounds(0.5, 4.5);
    Bounds dashNumberBounds = new Bounds(2.0, 8.0);
    Bounds hueBounds = new Bounds(0.0, 1.0);
    Bounds brightnessBounds = new Bounds(0.5, 0.75);
    Bounds saturationBounds = new Bounds(0.5, 1.0);
    Bounds strokeWidthBounds = new Bounds(1.0, 3.0);
    Bounds speedBounds = new Bounds(50.0, 100.0);
    Bounds angleIncrementBounds = new Bounds(1.0, 10.0);
    Bounds hueIncrementBounds = new Bounds(0.01, 0.05);
    Bounds scaleRateBounds = new Bounds(0.005, 0.01);
    Bounds scaleBounds = new Bounds(0.0, 1.0);
    final int UP = 1;
    final int DOWN = 0;
    Rectangle[] box = new Rectangle[4];
    float[] hue = new float[4];
    float[] brightness = new float[4];
    int[] armCount = new int[4];
    BasicStroke[] stroke = new BasicStroke[4];
    boolean[] spinning = new boolean[4];
    int[] count = new int[4];
    double[] angleIncrement = new double[4];
    float[] hueIncrement = new float[4];
    double[] scale = new double[4];
    double[] scaleRate = new double[4];
    int[] direction = new int[4];
    Runner runner;

    public ScaleTest() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = 0;
                boolean bl = false;
                n = 0;
                while (n < ScaleTest.this.box.length && !bl) {
                    if (ScaleTest.this.box[n].contains(mouseEvent.getPoint())) {
                        bl = true;
                        continue;
                    }
                    ++n;
                }
                if ((mouseEvent.getModifiers() & 2) != 0) {
                    ScaleTest.this.generateRandomArmCount(n);
                } else if ((mouseEvent.getModifiers() & 8) != 0) {
                    ScaleTest.this.generateRandomStroke(n);
                } else if ((mouseEvent.getModifiers() & 1) != 0) {
                    ScaleTest.this.generateRandomAngleIncrement(n);
                } else {
                    ScaleTest.this.toggleSpin(n);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){
            int pad = 20;

            public void componentResized(ComponentEvent componentEvent) {
                int n = Math.max(0, Math.min(this.pad, Math.min(ScaleTest.this.getWidth() - 2 * ScaleTest.this.minSize, ScaleTest.this.getHeight() - 2 * ScaleTest.this.minSize)));
                Dimension dimension = new Dimension((ScaleTest.this.getWidth() - 3 * n) / 2, (ScaleTest.this.getHeight() - 3 * n) / 2);
                for (int i = 0; i < ScaleTest.this.box.length; ++i) {
                    ScaleTest.this.box[i].x = i == 0 || i == 2 ? n : 2 * n + dimension.width;
                    ScaleTest.this.box[i].y = i == 0 || i == 1 ? n : 2 * n + dimension.height;
                    ScaleTest.this.box[i].width = dimension.width;
                    ScaleTest.this.box[i].height = dimension.height;
                }
            }
        });
        for (int i = 0; i < 4; ++i) {
            this.box[i] = new Rectangle();
            this.hue[i] = this.hueBounds.boundedFloat();
            this.hueIncrement[i] = this.hueIncrementBounds.boundedFloat();
            this.brightness[i] = this.brightnessBounds.boundedFloat();
            this.spinning[i] = Math.random() < 0.6;
            this.scale[i] = this.scaleBounds.boundedDouble();
            this.scaleRate[i] = this.scaleRateBounds.boundedDouble();
            this.direction[i] = Math.random() < 0.5 ? 1 : 0;
        }
        this.generateRandomArmCount(-1);
        this.generateRandomStroke(-1);
        this.generateRandomAngleIncrement(-1);
        try {
            this.runner = new Runner((Object)this, this.getClass().getMethod("step", null), this.speedBounds.boundedInt());
            this.runner.setRunning(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace(System.err);
        }
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void generateRandomArmCount(int n) {
        if (n >= 0 && n < this.armCount.length) {
            this.armCount[n] = this.armNumberBounds.boundedInt();
        } else {
            for (int i = 0; i < this.armCount.length; ++i) {
                this.generateRandomArmCount(i);
            }
        }
    }

    public void generateRandomAngleIncrement(int n) {
        if (n >= 0 && n < this.angleIncrement.length) {
            this.angleIncrement[n] = this.angleIncrementBounds.boundedDouble();
        } else {
            for (int i = 0; i < this.angleIncrement.length; ++i) {
                this.generateRandomAngleIncrement(i);
            }
        }
    }

    public void generateRandomStroke(int n) {
        if (n >= 0 && n < this.stroke.length) {
            float[] fArray = new float[this.dashNumberBounds.boundedInt()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.dashLengthBounds.boundedFloat();
            }
            this.stroke[n] = new BasicStroke(this.strokeWidthBounds.boundedFloat(), 0, 2, 0.5f, fArray, 0.0f);
        } else {
            for (int i = 0; i < this.stroke.length; ++i) {
                this.generateRandomStroke(i);
            }
        }
    }

    public void toggleSpin(int n) {
        if (n >= 0 && n < this.spinning.length) {
            this.spinning[n] = !this.spinning[n];
        } else {
            for (int i = 0; i < this.spinning.length; ++i) {
                this.toggleSpin(i);
            }
        }
    }

    public void step() {
        for (int i = 0; i < 4; ++i) {
            if (!this.spinning[i]) continue;
            int n = i;
            this.count[n] = this.count[n] + 1;
            if (this.scaleBounds.upperBound() <= this.scale[i] && this.direction[i] == 1) {
                this.scale[i] = this.scaleBounds.upperBound();
                this.direction[i] = 0;
                continue;
            }
            if (this.scaleBounds.lowerBound() >= this.scale[i] && this.direction[i] == 0) {
                this.scale[i] = this.scaleBounds.lowerBound();
                this.direction[i] = 1;
                continue;
            }
            if (this.direction[i] == 1) {
                this.scale[i] = Math.min(this.scale[i] + this.scaleRate[i], this.scaleBounds.upperBound());
                continue;
            }
            if (this.direction[i] == 0) {
                this.scale[i] = Math.max(this.scale[i] - this.scaleRate[i], this.scaleBounds.lowerBound());
                continue;
            }
            System.err.println("We oughtn't get here: direction = " + this.direction[i]);
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (int i = 0; i < 4; ++i) {
            graphics2D.setStroke(this.stroke[i]);
            float f = 100.0f;
            GeneralPath generalPath = this.createStar(new Point2D.Float(f / 2.0f, f / 2.0f), this.armCount[i], f / 2.0f, (double)this.count[i] * this.angleIncrement[i]);
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(f, 0.0f);
            generalPath.lineTo(f, f);
            generalPath.lineTo(0.0f, f);
            generalPath.lineTo(0.0f, 0.0f);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.box[i].x, this.box[i].y);
            double d = (float)this.box[i].width / f;
            double d2 = (float)this.box[i].height / f;
            switch (i + 1) {
                case 1: {
                    affineTransform.scale(d, d2);
                    break;
                }
                case 2: {
                    affineTransform.scale(this.scale[i] * d, d2);
                    break;
                }
                case 3: {
                    affineTransform.scale(d, this.scale[i] * d2);
                    break;
                }
                case 4: {
                    affineTransform.scale(this.scale[i] * d, this.scale[i] * d2);
                    break;
                }
                default: {
                    affineTransform.scale(Math.random() * this.scale[i] * d, Math.random() * this.scale[i] * d2);
                }
            }
            this.hue[i] = (this.hue[i] + this.hueIncrement[i]) % 1.0f;
            graphics2D.setPaint(Color.getHSBColor(this.hue[i], this.saturationBounds.boundedFloat(), this.brightness[i]));
            graphics2D.draw(generalPath.createTransformedShape(affineTransform));
            graphics2D.setPaint(Color.getHSBColor(this.hue[i], this.saturationBounds.boundedFloat(), this.brightness[i]));
            graphics2D.draw(this.box[i]);
        }
    }

    public GeneralPath createStar(Point2D point2D, int n, double d, double d2) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < n; ++i) {
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            double d3 = Math.toRadians(d2 + (double)(i * 360 / n));
            generalPath.lineTo((float)(point2D.getX() + d * Math.cos(d3)), (float)(point2D.getY() + d * Math.sin(d3)));
        }
        return generalPath;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Scale Tester");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new ScaleTest());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

